#include "cv.h"
#include "highgui.h"
#include <stdio.h>
#include "defines.h"
#include "seguimiento.h"
#include "homografia.h"

void dibuja_cruz(int x,int y,IplImage* image,double Color){

	CvPoint pu1,pu2;
	pu1.x=x-10;
	pu1.y=y;
	pu2.x=x+10;
	pu2.y=y;
	cvLine(image,pu1,pu2,Color,1,8);
	pu1.x=x;
	pu1.y=y-10;
	pu2.x=x;
	pu2.y=y+10;
	cvLine(image,pu1,pu2,Color,1,8);

	CvPoint* puntos=0;
	puntos=(CvPoint*)malloc( 4 * sizeof(puntos[0]));
	int numpts;
	numpts=4;

	puntos[0]=p1;
	puntos[1]=p2;
	puntos[2]=p3;
	puntos[3]=p4;
	cvPolyLine( image, &puntos, &numpts,1, 1, Color, 1,8);

}


int get_Color_Hist_img(IplImage* img,int x,int y,int color){
	uchar* temp_ptr=&((uchar*)(img->imageData+img->widthStep*y))[x*3];
	return (int)temp_ptr[color];
}

void procesar_imagen(IplImage* image)
{	
	
	int ok=0;
	int x,y;
	int incrx,incry;
	CvPoint aux;
	int max=0;
	float m;
	//max_func=0;
	
	for (x=0;x<ancho;x++){
		for (y=0;y<alto;y++){
			if (get_Color_Hist_img(image,x,y,2)>=max){
			  //Si el punto es igual o mayor que el actual maximo
				 posy=y;//Almacenamos la posicion
				 posx=x;
				 max=get_Color_Hist_img(image,x,y,2);
				 //Es el nuevo maximo
			}
			
		}	
		
	}
	if (max>minimo_umbral)//Si el valor maximo es mayor que el umbral
		ok=1;//Afirmamos que es el punto del puntero
	
	incry=posy-antpos.y;
	//calculamos el desplazamiento realizado entre la ultima
	incrx=posx-antpos.x;
	//Posicion encontrada y la actual
	
	//Lo convertimos en un valor absoluto
	if (incrx<0) 
		incrx=incrx*(-1);
	if (incry<0) 
		incry=incry*(-1);

	/////////////////////si se ha detectado////////////////////////
		
	if (ok){
		// 1 Si entre la ultima vez detectado ha pasado un cierto intervalo se entiende como un clic
		if ((incrtiempo<15)&&(incrtiempo>5)){
			//clic producido
			CvPoint p;
			p.x=(int)AntCursorPos.x;
			p.y=(int)AntCursorPos.y;
			
			if(!((p.x>1024)||(p.x<0)||(p.y<0)||(p.y>768))){
			  //Beep(277,100);
			}

		}
		//incrtiempo=0;
		// 2 Si el incremento de movimiento es mayor de unos limites se considera
		// movimiento voluntario en caso contrario no se actualiza ninguna posicion.
		if(incrx>Incr||incry>Incr){
			//transformacion
		                aux=TransPunto(posx,posy);
				//printf("Detectado x=%d y=%d\n",aux.x,aux.y);
				AntCursorPos=aux;
				//SetCursorPos((int)(aux.x),(int)((aux.y)));
			//fin transformacion
			if(!((aux.x>1024)||(aux.x<0)||(aux.y<0)||(aux.y>768))){
				dibuja_cruz(posx,posy,image,CV_RGB(0,0,255));
				//SetCursorPos((int)(aux.x),(int)((aux.y)));
				antpos.x=posx;
				antpos.y=posy;
				incrtiempo=0;
			}else{
				dibuja_cruz(posx,posy,image,CV_RGB(255,0,255));
				incrtiempo++;
			}
				
		}else{//Movimiento leve del laser
			aux=TransPunto(antpos.x,antpos.y);
			if(!((aux.x>1024)||(aux.x<0)||(aux.y<0)||(aux.y>768))){
				dibuja_cruz(antpos.x,antpos.y,image,CV_RGB(0,0,255));
				incrtiempo=0;
			}else{
				dibuja_cruz(antpos.x,antpos.y,image,CV_RGB(255,0,255));
				incrtiempo++;
			}
		}
			
	}
	/////////////////Sino se detecta el punto////////////////////////
	else{
		dibuja_cruz(antpos.x,antpos.y,image,CV_RGB(255,0,0));
		incrtiempo++;
	}
	
}

