#include "cv.h"
#include "cvcam.h"
#include "highgui.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <unistd.h>


#include "seguimiento.h"
#include "defines.h"
#include "homografia.h"
//#include "calib.h"
#include "camara.h"


 Display *dis;
 int screen;
 Window win;
 GC gc;


void init_x() {
  /* Para coger los colores blanco y negro */
  unsigned long black,white;

  dis=XOpenDisplay((char *)0);
  screen=DefaultScreen(dis);
  black=BlackPixel(dis,screen);
  white=WhitePixel(dis,screen);

  /* creamos la ventana */
  win=XCreateSimpleWindow(dis,DefaultRootWindow(dis),0,0,  
                          110, 150, 5, white, black);

  /* propiedades de la ventana */
  XSetStandardProperties(dis,win,"Puntero Interactivo","VxC",None,NULL,0,NULL);

  XSetWindowBackground(dis, win, 0x3a4a4d);

  /* seleccionamos qu tipos de eventos deseamos recibir */
  XSelectInput(dis, win, ExposureMask|ButtonPressMask|KeyPressMask);

  gc=XCreateGC(dis, win, 0,0);        
  XSetBackground(dis,gc,black);
  XSetForeground(dis,gc,white);
  XClearWindow(dis, win);
  XMapRaised(dis, win);
 
  
  
}

void close_xwin() {
  XFreeGC(dis, gc);
  XDestroyWindow(dis,win);
  XCloseDisplay(dis);
  exit(0);
}

void onMouse(int x, int y){
  if((y>20)&(y<50)){
    //iniHomografia();
    comenzarProcesado(1);
  }
	if((y>50)&(y<80))
	  paraProcesado();
	if((y>80)&(y<110))
	   comenzarProcesado(0);
	if((y>110)&(y<130))
	  close_xwin();
}

void crearBoton(int x,int y,int w,int h,char* texto,int tam){
	/*arrayBotones[numBoton].x=x;
	arrayBotones[numBoton].y=y;
	arrayBotones[numBoton].ancho=w;
	arrayBotones[numBoton].alto=h;
	arrayBotones[numBoton].accion=texto;
	numBoton++;
	*/
	XDrawRectangle(dis, win, gc, x, y, w, h);
	XDrawString( dis, win, gc, x+5 ,y+15 , texto, tam);
}

void redraw(){
int x=20;
int y=20;
crearBoton(x,y,70,20,"Comenzar",8);
crearBoton(x,y+30,70,20,"Parar",5);
crearBoton(x,y+60,70,20,"Capturar imagen",8);
crearBoton(x,y+90,70,20,"Salir",5);

}



int main(int argc, char* argv[]){
  char* valor;
  if(argc >= 2){
    valor=argv[1];
    minimo_umbral=(int)argv[1];
    printf("umbral: %d\n",minimo_umbral);
  }else{
     minimo_umbral=200;
     printf("umbral por defecto 200\n");
  }
  antpos.x=0;
  antpos.y=0;
  AntCursorPos.x=0;
  AntCursorPos.y=0;
  Incr=1;
  posx=0;
  posy=0;


   iniHomografia();

	fondo=cvCreateImage(cvSize(ancho,alto),8,3);
	cvZero(fondo);

  XEvent event;   
  char key;       

 init_x(); 

  
  int terminar=1;
  while(terminar) {
    XNextEvent(dis, &event);

    switch(event.type)      
    {  

    case Expose:
            
            if( event.xexpose.count == 0 ) ;
             redraw();
            break;
    
    case KeyPress:   
            key = XKeycodeToKeysym(dis, event.xkey.keycode, 0);
            if(key == 'q') 
	    	terminar=0;
            //printf("has pulsado la tecla %c !\n",key);
            break;
    
    case ButtonPress:
      //printf("Has pulsado un boton en (%i,%i)\n",event.xbutton.x,event.xbutton.y);
	onMouse(event.xbutton.x,event.xbutton.y);
      break;
      }
    }
    
 close_xwin();

    
 return 0;
}


