#include "cv.h"
#include "highgui.h"


#include "defines.h"

#include <stdio.h>






void CalcMH(){
  //puntos de las esquinas del escritorio que para este caso es una resolucin de 1024x768, estas son en el programa final detectadas por el sistema operativo
	CvPoint u1,u2,u3,u4;
	u1.x=0;u1.y=768;//0-1
	u2.x=1024;u2.y=768;//1-1
	u3.x=1024;u3.y=0;//1-0
	u4.x=0;u4.y=0;//0-0


//Definicion de la matriz A, a partir de los puntos del escritorio (U) y los puntos de la calibracin manual o automatica (p)
	double A[]={
   		p1.x,	p1.y,	1,	0,	0,	0,	-u1.x*p1.x,	-u1.x*p1.y,
		0,	0,	0,	p1.x,	p1.y,	1,	-p1.x*u1.y,	-p1.y*u1.y,
		p2.x,	p2.y,	1,	0,	0,	0,	-u2.x*p2.x,	-u2.x*p2.y,
		0,	0,	0,	p2.x,	p2.y,	1,	-p2.x*u2.y,	-p2.y*u2.y,
		p3.x,	p3.y,	1,	0,	0,	0,	-u3.x*p3.x,	-u3.x*p3.y,
		0,	0,	0,	p3.x,	p3.y,	1,	-p3.x*u3.y,	-p3.y*u3.y,
		p4.x,	p4.y,	1,	0,	0,	0,	-u4.x*p4.x,	-u4.x*p4.y,
		0,	0,	0,	p4.x,	p4.y,	1,	-p4.x*u4.y,	-p4.y*u4.y
		};
//Definicion de la matriz U
	double U[8]={u1.x,u1.y,u2.x,u2.y,u3.x,u3.y,u4.x,u4.y};
	//Inicializamos las matrizes de OpenCV donde trabajaremos
	CvMat MA,MU;
	cvInitMatHeader( &MA, 8, 8, CV_64FC1, A,CV_AUTOSTEP );//Funcion que inicializa una matriz y asigna un Array a dicha matriz
	cvInitMatHeader( &MU, 8, 1, CV_64FC1, U,CV_AUTOSTEP );
	//creamos matriz inversa de A;
	CvMat MAinv;
	double Ainv[64];
	cvInitMatHeader( &MAinv, 8, 8, CV_64FC1, Ainv,CV_AUTOSTEP );
	cvInvert(&MA,&MAinv,CV_SVD);//cvmInvert(&MA,&MAinv);
	//obtenemos la matriz h
	CvMat Mh;
	double h[8];
	cvInitMatHeader( &Mh, 8, 1, CV_64FC1, h ,CV_AUTOSTEP);
	cvmMul(&MAinv,&MU,&Mh);
	//Creamos la matriz H;
	double H[9];
	int i=0;
	for(i=0;i<8;i++)
		H[i]=h[i];
	H[8]=1.0;
	//Almacenamos la matriz H
	cvInitMatHeader(&MH,3,3,CV_64FC1,H,CV_AUTOSTEP);
}


CvPoint TransPunto(int x,int y){
  //CvPoint2D32f aux;
  CvPoint aux;
	CvMat Maux,Maux1;
	//Creamos los arrays necesarios para almacenar los puntos
	double mp[]={x,y,1};//Punto dado
	double mp1[3];//punto resultado de la equacin p'=Hp
	
	//Inicializamos las estructuras de matrices de openCV
	cvInitMatHeader( &Maux, 3, 1, CV_64FC1, mp,CV_AUTOSTEP);
	cvInitMatHeader( &Maux1, 3, 1, CV_64FC1, mp1,CV_AUTOSTEP);
	//Realizamos la operacin MHMp=Mp'
	cvmMul(&MH,&Maux,&Maux1);
	//El resultado devuelto ser una matriz p1 de 3 filas y una columna, de donde el punto equvalente x'=p1[0]/p1[2] y'=p1[1]/p1[2]
//p1[2] es el factor escala o como se definia en la funcion lambda
	aux.x=(int)(mp1[0]/mp1[2]);
	aux.y=(int)(768-(mp1[1]/mp1[2]));
	//printf("Detectado x=%d y=%d\n",aux.x,aux.y);
	//Devolvemos el punto obtenido
	return (aux);

}

void iniHomografia(){
	FILE* f;
	char nada[10];

	if( (f=fopen("calibracion.dat","r")) == NULL ){
	  p1.x=0;
	  p1.y=480;
	  p2.x=640;
	  p2.y=480;
	  p3.x=640;
	  p3.y=0;
	  p4.x=0;
	  p4.y=0;       
	  
	  printf("Debe calibrar primero la camara\nEjejute calibracion imagen.jpg\n");
	  //exit(-1);
	}else{
		fscanf(f,"%s %d %d",nada,&p1.x,&p1.y);
		fscanf(f,"%s %d %d",nada,&p2.x,&p2.y);
		fscanf(f,"%s %d %d",nada,&p3.x,&p3.y);
		fscanf(f,"%s %d %d",nada,&p4.x,&p4.y);
	
	
	}
	printf("%d,%d-%d,%d-%d,%d-%d,%d\n",p1.x,p1.y,p2.x,p2.y,p3.x,p3.y,p4.y,p4.y);
	CalcMH();
	CvPoint p=TransPunto(p1.x,p1.y);
	printf("%d,%d\n",p.x,p.y);
	p=TransPunto(p2.x,p2.y);
	printf("%d,%d\n",p.x,p.y);
	p=TransPunto(p3.x,p3.y);
	printf("%d,%d\n",p.x,p.y);
	p=TransPunto(p4.x,p4.y);
	printf("%d,%d\n",p.x,p.y);
}
