// ejemplo2.cpp: define el punto de entrada de la aplicacin de consola.
// En este ejemplo se describir como crear una ventana en openCV asi como
// Mostrar una imagen


#include "highgui.h"
#include "stdio.h"

#define ventana "Histograma"
#define ventana1 "Ejemplo2-2"
#define ventana2 "Imagen Umbralizada"

IplImage* dst_image;
IplImage* imageUmbral;
IplImage* imagen1;

int hist_size = 256;
int valorInicial=100;
int valorInicial1=10000;

float range_0[]={0,256};
float* ranges[] = { range_0 };

CvHistogram *hist;
int rellenar=0;
int valorUmbral=100;



int get_Color_img(IplImage* img,int x,int y){
	uchar temp_ptr=((uchar*)(img->imageData+img->widthStep*y))[x];
	return (int)temp_ptr;
}
int set_Color_img(IplImage* img,int x,int y,int color){
	uchar* temp_ptr=&((uchar*)(img->imageData+img->widthStep*y))[x];
	temp_ptr[0]=(uchar)color;
}

int umbralizar(int valor){
	int x;
	int y;
	int color=0;
	for (x=0;x<imagen1->width;x++){
		for(y=0;y<imagen1->height;y++){
			if(get_Color_img(imagen1,x,y)>valor)
				color=255;
			else
				color=0;
			set_Color_img(imageUmbral,x,y,color);
		}
	}
}

void escala(int arg){
	if(arg!=0)
		cvNormalizeHist( hist, arg );
	else
		cvNormalizeHist( hist, 1 );
	int i;
    	int numPoints=256;
    	CvPoint* puntos=0;
	puntos=(CvPoint*)malloc( numPoints * sizeof(puntos[0]));
	
    	CvPoint pt1, pt2;
    
	cvZero( dst_image );
	cvRectangle( dst_image, cvPoint(0,0), cvPoint(256,200),CV_RGB(255,255,255),-1);
	
	pt1.x = pt2.x = 0;
	pt2.y = dst_image->height;
	
	for( i = 0; i < hist_size; i++ )
	{
		pt1.y = cvRound(dst_image->height - cvQueryHistValue_1D(hist,i));
		//pt2.x += 3;
		pt2.x ++;
		puntos[i]=pt1;
		//cvRectangle( dst_image, pt1, pt2, 255, -1 );
		pt1.x = pt2.x;
	}
	cvPolyLine( dst_image, &puntos, &numPoints,1, 1, CV_RGB(0,0,255), 1, 0);
	if(rellenar==1)
		cvFillPoly( dst_image, &puntos, &numPoints, 1, CV_RGB(0,0,255) );
	
	cvLine(dst_image,cvPoint(50,0),cvPoint(50,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(100,0),cvPoint(100,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(150,0),cvPoint(150,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(200,0),cvPoint(200,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(255,0),cvPoint(255,dst_image->height),CV_RGB( 0, 255, 0 ),1,8);
	cvLine(dst_image,cvPoint(0,0),cvPoint(0,dst_image->height),CV_RGB( 0, 255, 0 ),1,8);
	
	
	cvLine(dst_image,cvPoint(valorUmbral,0),cvPoint(valorUmbral,dst_image->height),CV_RGB( 255, 0, 0 ),1,8);
	
	cvShowImage( ventana, dst_image );
	

}

void scroll( int arg )
{
	int i;
    	int numPoints=256;
	valorUmbral=arg;
    	CvPoint* puntos=0;
	puntos=(CvPoint*)malloc( numPoints * sizeof(puntos[0]));
	
    	CvPoint pt1, pt2;
    
	cvZero( dst_image );
	cvRectangle( dst_image, cvPoint(0,0), cvPoint(256,200),CV_RGB(255,255,255),-1);
	
	pt1.x = pt2.x = 0;
	pt2.y = dst_image->height;
	
	for( i = 0; i < hist_size; i++ )
	{
		pt1.y = cvRound(dst_image->height - cvQueryHistValue_1D(hist,i));
		//pt2.x += 3;
		pt2.x ++;
		puntos[i]=pt1;
		//cvRectangle( dst_image, pt1, pt2, 255, -1 );
		pt1.x = pt2.x;
	}
	cvPolyLine( dst_image, &puntos, &numPoints,1, 1, CV_RGB(0,0,255), 1, 0);
	if(rellenar==1)
		cvFillPoly( dst_image, &puntos, &numPoints, 1, CV_RGB(0,0,255) );
	
	cvLine(dst_image,cvPoint(50,0),cvPoint(50,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(100,0),cvPoint(100,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(150,0),cvPoint(150,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(200,0),cvPoint(200,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(255,0),cvPoint(255,dst_image->height),CV_RGB( 0, 255, 0 ),1,8);
	cvLine(dst_image,cvPoint(0,0),cvPoint(0,dst_image->height),CV_RGB( 0, 255, 0 ),1,8);
	
	
	cvLine(dst_image,cvPoint(arg,0),cvPoint(arg,dst_image->height),CV_RGB( 255, 0, 0 ),1,8);
	cvShowImage( ventana, dst_image );
	
	umbralizar(arg);
	cvShowImage( ventana2, imageUmbral );
	
}

int main(int argc, char* argv[])
{

    int i;
    int j;
    int numPoints=256;
    CvPoint* puntos=0;
	puntos=(CvPoint*)malloc( numPoints * sizeof(puntos[0]));
	
    CvPoint pt1, pt2;


	printf("---------------------------------\n"
		"Ejemplo 2 - David Millan - Highgui\n"
		"----------------------------------\n"
		"Uso: histograma [opciones]\n"
		"-i imagen : Imagen a mostrar\n"
		"r : Rellenamos el histograma con color\n"
		"Hot keys:\n"
		"   Esc,q,Q - Salir\n\n");

	char* filename;
		
	if (argc>=2){
		for(j=1;j<argc;j=j+2)
		{
			
			if(!strcmp(argv[j],"-i"))
				filename = argv[j+1];
			if(!strcmp(argv[j],"-r"))
				rellenar=1;
			
		}
	}else{	
		filename = argc == 2 ? argv[1] : (char*)"fondo1.jpg";
	}
		
	hist = cvCreateHist(1, &hist_size, CV_HIST_ARRAY, ranges, 1);
	
	//Cargamos la imagen en Escala de grises
	//(archivo,int a) a>0:RGB; a=0:Escala Grises; a<0:la de la imagen
	imagen1=cvLoadImage(filename,0);
	imageUmbral=cvCloneImage(imagen1);
		//dst_image = cvCloneImage(imagen1);
	dst_image=cvCreateImage(cvSize(256,200),8,3);
	cvCalcHist( &imagen1, hist, 0, NULL );
	cvZero( dst_image );
	cvRectangle( dst_image, cvPoint(0,0), cvPoint(256,200),CV_RGB(255,255,255),-1);
	cvNormalizeHist( hist, valorInicial1 );
	
	pt1.x = pt2.x = 0;
	pt2.y = dst_image->height;
	
	for( i = 0; i < hist_size; i++ )
	{
		pt1.y = cvRound(dst_image->height - cvQueryHistValue_1D(hist,i));
		//pt2.x += 3;
		pt2.x ++;
		puntos[i]=pt1;
		//cvRectangle( dst_image, pt1, pt2, 255, -1 );
		pt1.x = pt2.x;
	}
	cvPolyLine( dst_image, &puntos, &numPoints,1, 1, CV_RGB(0,0,255), 1, 0);
	if(rellenar==1)
		cvFillPoly( dst_image, &puntos, &numPoints, 1, CV_RGB(0,0,255) );
	
   	cvLine(dst_image,cvPoint(50,0),cvPoint(50,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(100,0),cvPoint(100,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(150,0),cvPoint(150,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(200,0),cvPoint(200,dst_image->height),CV_RGB( 55, 0, 0 ),1,8);
	cvLine(dst_image,cvPoint(255,0),cvPoint(255,dst_image->height),CV_RGB( 0, 255, 0 ),1,8);
	cvLine(dst_image,cvPoint(0,0),cvPoint(0,dst_image->height),CV_RGB( 0, 255, 0 ),1,8);
	
	cvLine(dst_image,cvPoint(100,0),cvPoint(100,dst_image->height),CV_RGB( 255, 0, 0 ),1,8);
	
	cvNamedWindow(ventana,0);
	cvNamedWindow(ventana1,0);
	cvNamedWindow(ventana2,0);
	//Mostramos la imagen en la ventana
	//cvShowImage(ventana,imagen);
	umbralizar(100);
	cvShowImage( ventana2, imageUmbral );
	
	cvShowImage(ventana1,imagen1);
	cvShowImage( ventana, dst_image );
	
	 
	cvCreateTrackbar("Escala", ventana, &valorInicial1,500000, escala);
	cvCreateTrackbar("Umbral", ventana, &valorInicial, 256, scroll);
	
	
		
	 for(;;)
    	{
		int key;
		key = cvWaitKey(0);
        if( key == 27 || key == 'q' || key == 'Q' ) // 'ESC', q o Q
            break;
	}
	cvDestroyAllWindows();//Destruimos todas las ventanas
	return 0;
}

