#include "cv.h"
#include "cvcam.h"
#include "highgui.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#include "defines.h"
#include "homografia.h"
#include "calib.h"
#include "seguimiento.h"

Display *display;
Window ventana;
int capProc=0;

IplImage* anterior;
void callback(IplImage* image)
{
  cvcamPause();
  if(!capProc)
    cvSaveImage("fondo1.jpg",image);
  else
    procesar_imagen(image);
  cvcamResume();
}

void comenzarProcesado(int que){
  capProc=que;
	CvCapture* cvcamone;
	XInitThreads();
	int ncams = cvcamGetCamerasCount( );
	cvcamSetProperty(0, CVCAM_PROP_ENABLE, &cvcamone);
	cvcamSetProperty(0, CVCAM_PROP_RENDER, &cvcamone);
	//inicializamos la imagen para hacecr procesos
	anterior=cvCreateImage(cvSize(ancho,alto),8,3);
	cvZero(anterior);
	
	//funciones de X11
	
    /* abrimos el display estándar */
	display = XOpenDisplay( NULL );
    /* creamos una nueva ventana */
	ventana = XCreateSimpleWindow( display, RootWindow( display, 0), 10, 50, ancho, alto, 2, 0, 1 );
    /* Definimos las propiedades la ventana */
	XSetStandardProperties(display, ventana, "Visualizacion","PFC",None,NULL,0,NULL);
        /* Mapeamos la ventana para hacerla visible */
	XMapWindow( display, ventana );
	XFlush( display );
	
	
	cvcamSetProperty(0, CVCAM_PROP_WINDOW, &ventana);   
	cvcamSetProperty(0, CVCAM_PROP_CALLBACK, callback);
	
	
	if(cvcamInit( )<0)
		exit(-1);
	
	if(cvcamStart( )<0)
		exit(-1);
	
	
	//printf("-->%d",(int)display);
	//printf("<-->%d",(int)ventana);

}

void paraProcesado(){
	cvcamStop( );
	cvcamExit( );
	//printf("-->%d",(int)display);
	//printf("<-->%d",(int)ventana);
	//printf("------%d %d",(int)XDestroyWindow(display, ventana),BadWindow);
	XCloseDisplay(display);
	
}
