#include "cv.h"
#include "highgui.h"

#include <stdio.h>

#define ancho 640
#define alto 480

//Funcion que a partir de un punto dado, calcula en que sector donde se encuentra y redibuja el poligono de 4 puntos que 
//Sirve como las esquinas de calibracin
IplImage* img_Calib;
IplImage* fondo;
CvPoint p1;
CvPoint p2;
CvPoint p3;
CvPoint p4;
int puedoEscuchar=0;

void guardarDatos(){
	FILE* f;

	f=fopen("calibracion.dat","w");

	fprintf(f,"Punto1: %d %d\n",p1.x,p1.y);
	fprintf(f,"Punto2: %d %d\n",p2.x,p2.y);
	fprintf(f,"Punto3: %d %d\n",p3.x,p3.y);
	fprintf(f,"Punto4: %d %d\n",p4.x,p4.y);
	printf("Guardando puntos:\n");
	printf("Punto1: %d %d\n",p1.x,p1.y);
	printf("Punto2: %d %d\n",p2.x,p2.y);
	printf("Punto3: %d %d\n",p3.x,p3.y);
	printf("Punto4: %d %d\n",p4.x,p4.y);
}

void situarPuntoCalibracion(int x,int y){
	CvPoint* puntos=0;
	puntos=(CvPoint*)malloc( 4 * sizeof(puntos[0]));
	int numpts=4;
	img_Calib=cvCloneImage(fondo);
	//Ponemos los puntos segun han pinchado
	if ((x!=-1)||(y!=-1))
	{
		if(x<(ancho/2)){//sectores 1 y 4
			if(y>(alto/2)){
				//sector 1
				p1.x=x;
				p1.y=y;
			}else{
				//sector 4
				p4.x=x;
				p4.y=y;
			}
		}else{//sectores 2 y 3
			if(y>(alto/2)){
				//sector 2
				p2.x=x;
				p2.y=y;
			}else{
				//sector 3
				p3.x=x;
				p3.y=y;
			}
		}
	}
	puntos[0]=p1; puntos[1]=p2; puntos[2]=p3; puntos[3]=p4;
	cvPolyLine( img_Calib, &puntos, &numpts,1, 1, CV_RGB(0,0,255), 1, 0);
	cvShowImage("Calibracin Manual",img_Calib);
}
//Funcion de captura de eventos del ratn
void on_mouse_calib( int event, int x, int y, int flags )
{ 
    switch( event )
    {
    	case CV_EVENT_LBUTTONUP:{
			puedoEscuchar=0;
			situarPuntoCalibracion(x,y);
		}break;
	case CV_EVENT_LBUTTONDOWN:{
			puedoEscuchar=1;
		}break;
	case CV_EVENT_MOUSEMOVE:{
			if(puedoEscuchar==1)
				situarPuntoCalibracion(x,y);
		}break;	
    }
}
//Funcion de inicializacion de la calibracin manual
//Crea la ventana de interactuacin y  elementos necesarios.
void calib_manual(){
	//Creamos la ventana
	char* name="Calibracin Manual";
	cvNamedWindow(name,0);
	cvResizeWindow( name, ancho, alto );
	//Creamos una cruz de quia para separar los sectores
	CvPoint pq1=cvPoint(ancho/2,0);
	CvPoint pq2=cvPoint(ancho/2,alto);
	CvPoint pq3=cvPoint(0,alto/2);
	CvPoint pq4=cvPoint(ancho,alto/2);
	cvLine(fondo,pq1,pq2,CV_RGB(0,255,0),1,8);
	cvLine(fondo,pq3,pq4,CV_RGB(0,255,0),1,8);
	//Clonamos la imagen de fondo para trabajar sobre ella
	img_Calib=cvCloneImage(fondo);
	//Creamos los eventos de ratn
	cvSetMouseCallback( name, on_mouse_calib );
	//comenzamos la calibracin
	situarPuntoCalibracion(-1,-1);
}
int main(int argc, char* argv[]){
  char* filename;
  if(argc >= 2)
    filename= argv[1];
  else{
    printf("Debe especificar un archivo.\n\tEjemplo:\n\t./calibracion file.jpg\n");
    exit(-1);
  }
	printf("Puntero Interactivo\n"
	"---------------------------------------\n"
	"Calibrarion.\n"
	"Autor: David Millan\n"
	"Tutor: Manuel Agust\n"
	"----------------------------------------\n"
	"Pulsa sobre la ventana situar los puntos de calibracin\n"
	"\n"
	"Hot keys:\n"
	"   Esc,q,Q - Salir\n"
	"   g       - Guardar puntos\n\n");
	

  p1.x=ancho/2;p1.y=alto/2;
  p2.x=ancho/2;p2.y=alto/2;
  p3.x=ancho/2;p3.y=alto/2;
  p4.x=ancho/2;p4.y=alto/2;
  fondo=cvLoadImage(filename,1);
  calib_manual();
  for(;;){   
	int key;
	key = cvWaitKey(100);
       	if( key == 27 || key == 'q' || key == 'Q' ) // 'ESC', q o Q
           break;
	if( key=='g'){
	   guardarDatos();
	}
  }
  cvDestroyAllWindows();//Destruimos todas las ventanas
  return 0;
}
